/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMBean;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jspecify.annotations.Nullable;

public final class CommonHooks {
    public static final ResourceLocation TREASURE_DISK_LOOT = new ResourceLocation("computercraft", "treasure_disk");
    private static final Set<ResourceLocation> TREASURE_DISK_LOOT_TABLES = Set.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78763_, BuiltInLootTables.f_78762_, BuiltInLootTables.f_78761_, BuiltInLootTables.f_78764_, BuiltInLootTables.f_78686_, BuiltInLootTables.f_78688_, BuiltInLootTables.f_78689_, BuiltInLootTables.f_78746_);

    private CommonHooks() {
    }

    public static void onServerTickStart(MinecraftServer server) {
        ServerContext.get(server).tick();
        TickScheduler.tick();
    }

    public static void onServerTickEnd() {
        MonitorWatcher.onTick();
    }

    public static void onServerStarting(MinecraftServer server) {
        if (server instanceof DedicatedServer) {
            DedicatedServer dediServer = (DedicatedServer)server;
            if (dediServer.m_7913_().f_139721_) {
                ComputerMBean.register();
            }
        }
        CommonHooks.resetState();
        ServerContext.create(server);
        ComputerMBean.start(server);
    }

    public static void onServerStopped() {
        CommonHooks.resetState();
    }

    private static void resetState() {
        ServerContext.close();
        NetworkUtils.reset();
    }

    public static void onServerChunkUnload(LevelChunk chunk) {
        if (!(chunk.m_62953_() instanceof ServerLevel)) {
            throw new IllegalArgumentException("Not a server chunk.");
        }
        TickScheduler.onChunkUnload(chunk);
    }

    public static void onChunkWatch(LevelChunk chunk, ServerPlayer player) {
        MonitorWatcher.onWatch(chunk, player);
    }

    public static void onChunkTicketLevelChanged(ServerLevel level, long chunkPos, int oldLevel, int newLevel) {
        TickScheduler.onChunkTicketChanged(level, chunkPos, oldLevel, newLevel);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LootPool.Builder getExtraLootPool(ResourceLocation lootTable) {
        if (!lootTable.m_135827_().equals("minecraft") || !TREASURE_DISK_LOOT_TABLES.contains(lootTable)) {
            return null;
        }
        return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)TREASURE_DISK_LOOT)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
    }

    public static void onDatapackReload(BiConsumer<String, PreparableReloadListener> addReload) {
        addReload.accept("mounts", (PreparableReloadListener)ResourceMount.RELOAD_LISTENER);
        addReload.accept("turtle_upgrades", (PreparableReloadListener)TurtleUpgrades.instance());
        addReload.accept("pocket_upgrades", (PreparableReloadListener)PocketUpgrades.instance());
    }

    public static boolean onEntitySpawn(Entity entity) {
        return DropConsumer.onEntitySpawn(entity);
    }

    public static boolean onLivingDrop(Entity entity, ItemStack stack) {
        return DropConsumer.onLivingDrop(entity, stack);
    }

    public static void onBuildCreativeTab(ResourceKey<CreativeModeTab> key, CreativeModeTab.ItemDisplayParameters context, CreativeModeTab.Output out) {
        if (key == CreativeModeTabs.f_256837_ && context.f_268429_()) {
            out.m_246326_((ItemLike)ModRegistry.Items.COMPUTER_COMMAND.get());
        }
    }
}

